;
;	   hider file for ATtiny2313 chip
;		version 1.02 KOBRA softvare
;		  for version2 assembler!
;------------------------------------------------------
;
;	Projekt _______
;	Filename ______
;	File version __
;	Autor _________
;
;------------------------------------------------------
;  :
;
; CKDIV8=0 (  . rc- 8 
;            clkps 3-0 = 0011 / =8/ )
;			    
;			   
;	    clkps 3-0  !!!
; CKOUT=1   (FOR OUT=0)
; SUT1:SUT0=10(.max)    
; CKSEL3:CKSEL2:CKSEL1:CKSEL0=0100(..r-c  8)
; 	110x  3-8;  111x  >8
; 	   
; 	   (CKSEL0)
;
;			!!!
;    ATtiny2313   
;     RC .
;     000   
;      8 MHz.  
;     OSCCAL    .
;    
;      4 MHz  !
; ,     
;    RC    4 MHz
;    .
;        4 MHz
;      001   .
;
; DWEN=1  gebugWire  (0-)
; EESAVE=1    EEPROM - 1 , 0  
; SPIEN=0    (1-)
; WDTON=1 WDT     (0- )
; SELFPRGEN=1  ( SPM)  (0-)
; BODLEVEL2:BODLEVEL1:BODLEVEL0=111 ()
; 	   BOR(  ,    ,
;       )
; RSTDISBL=1  RST    (0-    " !!!)
;
;       
;,   ,   LPM.
;        
; !
;      WDE (WDTCSR)    
;         
;         !
;------------------------------------------------------
;
;    :
;
; CKDIV8=0 (  . rc- 8 
;            clkps 3-0 = 0011 / =8/ )
; CKOUT=1
; SUT1:SUT0=10 (.max)    
; CKSEL3:CKSEL2:CKSEL1:CKSEL0=0100 (..r-c  8)
; DWEN=1  gebugWire 
; EESAVE=1    EEPROM - 1 
; SPIEN=0   
; WDTON=1 WDT    
; SELFPRGEN=1  ( SPM) 
; BODLEVEL2:BODLEVEL1:BODLEVEL0=111 ()
; RSTDISBL=1  RST    (0-    " !!!)
;------------------------------------------------------
		.nolist
		.include "tn2313def.inc"
		.list
; -----------------------------------------------------
.include "librus/mdf_tn2313ast.txt" ;   ,   
;  .include "macros_name project.txt" ;   
;     name project     
;             name project = proto
;______________________________________________________
  .cseg
		.org 0x000
	irq_res:
		rjmp init ;      
; - - - - - - - - - - - - - - - - - - - - - - - - - - -
;     
		.org OC0Aaddr
	irq_t0:
		rjmp isf_gen ; steps
; - - - - - - - - - - - - - - - - - - - - - - - - - - -
;______________________________________________________
   .org (irq_res+int_vectors_size) ;    
; - - - - - - - - - - - - - - - - - - - - - - - - - - -
 isf_gen:
   sbi flags,isf ;   isf
   reti
; - - - - - - - - - - - - - - - - - - - - - - - - - - -
 init:                    ;   
;    outport
  clr zero
  out outport,zero
  ser tmp0
  out DDRB,tmp0
;    8000000
  ldi tmp0,1<<CLKPCE
  out CLKPR,tmp0
  out CLKPR,zero
;    
;  0   CTC     OCR0A
  ldi tmp0,1<<WGM01
  out TCCR0A,tmp0 ;       OCR0A
  ldi tmp0,tmdiv
  out OCR0A,tmp0 ;   
  ldi tmp0,1<<OCIE0A
  out TIMSK,tmp0 ;   OC0Aaddr 
  ldi lcnt,1 ;   vram    
             ;  darkslot
  rcall darkslot ;  darkslot
;     TCCR0B = 1<<CS00
  ldi tmp6,1<<CS00
  out TCCR0B,tmp6
  sei ;  
;     isf
;       ,
;     fnptr
 loop:
  sbic flags,isf
  icall ;      Zh:Zl
  rjmp loop
;
;-------------------------------------------------------------------

;    () 
;        
;  A   B (A+4)

point:
  out outport,tmpd ;    tmpd  outport
                   ;(  )
  inc scnt ; scnt++   
;     255 (   -   127)
;       () endpoint
  breq endpoint
;   tmpd     :
  cp tmpa,scnt
  brcc tp00
  andi tmpd,blank_a ;  tmpa < scnt   tmpd.pcnt
tp00:
  cp tmpb,scnt
  brcc endspl
  andi tmpd,blank_b ;  tmpb < scnt   tmpd.(pcnt+4)

endspl:
  cbi flags,isf ;   isf
  ret ;      ()

;
;-------------------------------------------------------------------

;     ()
endpoint:
  inc pcnt ;   +1 (pcnt++)
  cpi pcnt,4
  brne linstart
  ldiw Z,darkslot ;  pcnt = 4
                ;    fnptr  darkslot
  rjmp endspl ;    endspl
  
linstart:
  lsl spmask ;     spmask<<1 ( RL-)
linstart2:
;    
  ld tmpa,X+ ; tmpa = *ptra
  ld tmpb,Y+ ;  tmpb = *ptrb
  mov tmpd,spmask ;      
            ;        
  tst tmpa ;  tmpa = 0   tmpd.pcnt = 0
  brne tp01
  andi tmpd,blank_a
tp01:
  tst tmpb ;  tmpb = 0   tmpd.pcnt = 0
  brne tp02
  andi tmpd,blank_b
tp02:
  ldi scnt,1 ; scnt = 1
  rjmp endspl ;     endspl

;
;-------------------------------------------------------------------

; " "  

darkslot:
  out outport,zero ;  
;       vram
  dec lcnt
  brne nomode
  rcall step_has ;     vram
          ;      
          ;     lcnt
  ldi lcnt,hastep
nomode:
  ldi tmp6,spmaskdat ;   
  mov spmask,tmp6 ;     spmask
  ldiw Z,point ;    fnptr  point
  clr pcnt ; pcnt = 0
  ldiw X,vram ; ptra = vram
  ldiw Y,(vram+4) ; ptrb = vram+4
  rjmp linstart2 ;   linstart2 (  spmask)

;
;-------------------------------------------------------------------

.include "librus/has_r.txt" ;  -  
;
;-------------------------------------------------------------------

	.exit
